/*
 * Decompiled with CFR 0.152.
 */
package pse.core;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pse.assessment.AssessmentCompoundObservable;
import pse.assessment.AssessmentPrimaryObservable;
import pse.assessment.AssessmentReportingObservable;
import pse.assessment.AssessmentSmv;
import pse.assessment.AssessmentWorkProductFeature;
import pse.assessment.Network;
import pse.assessment.PantherAssessment;
import pse.assessment.PantherForm;
import pse.assessment.PantherTask;
import pse.assessment.TaskMetaData;
import pse.common.ActivityVariable;
import pse.common.NetworkConfiguration;
import pse.common.Presentation;
import pse.common.TopologyGraphic;
import pse.configuration.Fillin;
import pse.configuration.PageCollection;
import pse.core.PantherEngine;
import pse.result.CompoundEvidenceIdentification;
import pse.result.CompoundObservable;
import pse.result.EvidenceAccumulation;
import pse.result.IosCommandEntry;
import pse.result.IosLog;
import pse.result.IosLogEntry;
import pse.result.PrimaryObservable;
import pse.result.Result;
import pse.result.Session;
import pse.result.Smv;
import pse.result.WorkProductFeature;
import pse.util.general.IipClient;
import pse.util.general.IipClientHandler;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IipGenerator {
    protected IipClient iipClient;
    protected PantherAssessment assessment;
    protected PantherEngine pantherEngine;
    protected PantherForm form;
    protected PantherTask task;
    protected PageCollection iipContent;
    protected Result scores;
    protected Object iipContext;
    protected List<AssessmentCompoundObservable> topLevelObservables;
    protected List<String> feedbackStrings;
    private boolean displayvariableSection = false;
    private boolean displayanswer = true;
    private boolean displayfeedbackSection = true;
    private boolean displaygeneralInformationScoring = true;
    private boolean displaytotalEarnedPoints = true;
    private boolean displayuserWork = true;
    protected static PageCollection DEFAULT_IIP_CONTENT;

    public IipGenerator(PantherEngine pantherEngine, Result result, PantherTask pantherTask, PantherForm pantherForm) {
        this(pantherEngine, result, pantherTask, pantherForm, null, IipClientHandler.DEFAULT, null);
    }

    public IipGenerator(PantherEngine pantherEngine, Result result, PantherTask pantherTask, PantherForm pantherForm, PageCollection pageCollection) {
        this(pantherEngine, result, pantherTask, pantherForm, pageCollection, IipClientHandler.DEFAULT, null);
    }

    public IipGenerator(PantherEngine pantherEngine, Result result, PantherTask pantherTask, PantherForm pantherForm, PageCollection pageCollection, IipClient iipClient, Object object) {
        this.pantherEngine = pantherEngine;
        this.scores = result;
        this.task = pantherTask;
        this.form = pantherForm;
        this.assessment = pantherForm.getAssessment();
        this.topLevelObservables = pantherTask.getTopLevelObservablesInOrder();
        this.feedbackStrings = this.getFeedbackStrings();
        this.iipClient = iipClient;
        this.iipContext = object;
        this.iipContent = pageCollection;
    }

    public void addFillin(Map<String, Fillin> map, String string, int n) {
        this.addFillin(map, string, String.valueOf(n));
    }

    public void addFillin(Map<String, Fillin> map, String string, String string2) {
        map.put(string, new Fillin(string, string2));
    }

    public String generate() throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.generate(printWriter, ".", true, true, false);
        printWriter.flush();
        return stringWriter.toString();
    }

    public void generate(PrintWriter printWriter, String string, boolean bl, boolean bl2, boolean bl3) throws Exception {
        this.generate(printWriter, string, bl, bl2, bl3, "No PKA link is available.");
    }

    public void generate(PrintWriter printWriter, String string, boolean bl, boolean bl2, boolean bl3, String string2) throws Exception {
        this.generate(printWriter, string, bl, bl2, bl3, null, string2);
    }

    public void generate(PrintWriter printWriter, String string, boolean bl, boolean bl2, boolean bl3, PageCollection pageCollection, String string2) throws Exception {
        this.iipContent = pageCollection;
        if (this.iipContent == null) {
            this.iipContent = IipGenerator.getDefaultIipContent();
        }
        AssessmentSmv assessmentSmv = this.form.getDefaultSmv();
        HashMap<String, Fillin> hashMap = new HashMap<String, Fillin>();
        this.addFillin(hashMap, "${ASSESSMENT_TITLE}", XmlUtils.escape(this.assessment.getTitle()));
        this.addFillin(hashMap, "${FORM_TITLE}", XmlUtils.escape(this.form.getTitle()));
        this.addFillin(hashMap, "${HTTP_ROOT}", string);
        this.addFillin(hashMap, "${IMAGES_ROOT}", string + "/images");
        this.addFillin(hashMap, "${TOTAL_POINTS_POSSIBLE}", assessmentSmv.getMaximumPoints());
        int n = this.task.getHighestCompoundLevel() + 1;
        this.addFillin(hashMap, "${NUMBER_OF_OBSERVABLE_LEVELS_PLUS_ONE}", String.valueOf(n + 1));
        this.addFillin(hashMap, "${NUMBER_OF_OBSERVABLE_LEVELS}", String.valueOf(n));
        this.addFillin(hashMap, "${NUMBER_OF_OBSERVABLE_LEVELS_MINUS_ONE}", String.valueOf(n - 1));
        this.addFillin(hashMap, "${NUMBER_OF_OBSERVABLE_LEVELS_MINUS_TWO}", String.valueOf(n - 2));
        this.addFillin(hashMap, "${NUMBER_OF_OBSERVABLE_LEVELS_MINUS_THREE}", String.valueOf(n - 3));
        this.addFillin(hashMap, "${NUMBER_OF_OBSERVABLE_LEVELS_MINUS_FOUR}", String.valueOf(n - 3));
        this.iipClient.customizeFillinMap(hashMap, this.assessment, this.form, this.task, this.scores, this.iipContext);
        this.addFillin(hashMap, "${PERFORMANCE_COMPONENT_SECTIONS}", this.generatePerformanceComponents(hashMap, bl));
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        if (this.scores != null) {
            try {
                EvidenceAccumulation evidenceAccumulation = this.scores.getEvidenceAccumulation();
                Smv smv = evidenceAccumulation.getSmv(assessmentSmv.getVdsIdent());
                String string10 = evidenceAccumulation.getServerTimeString();
                this.addFillin(hashMap, "${SCORED_DATE}", string10);
                this.addFillin(hashMap, "${TOTAL_EARNED_POINTS}", smv.getEarnedPoints());
                this.addFillin(hashMap, "${USER_ID}", this.scores.getXpassSession().getVdsUserId());
                string4 = this.generateFeedback(hashMap);
                string6 = this.iipContent.getPageContent("iip-general-information-scoring", hashMap);
                string7 = this.iipContent.getPageContent("iip-total-earned-points", hashMap);
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
        }
        if (bl) {
            string3 = this.generateAnswer(hashMap, bl2, bl3);
            string5 = this.generateVariables(hashMap);
            if (this.scores != null) {
                string8 = this.generateUserWork(hashMap, string2);
            }
        }
        this.addFillin(hashMap, "${ANSWER}", string3);
        this.addFillin(hashMap, "${FEEDBACK_SECTION}", string4);
        if (this.displayvariableSection) {
            this.addFillin(hashMap, "${VARIABLE_SECTION}", string5);
        } else {
            this.addFillin(hashMap, "${VARIABLE_SECTION}", "");
        }
        this.addFillin(hashMap, "${GENERAL_INFORMATION_SCORING}", string6);
        this.addFillin(hashMap, "${TOTAL_EARNED_POINTS}", string7);
        this.addFillin(hashMap, "${USER_WORK}", string8);
        string9 = this.generateToc(hashMap, bl);
        this.addFillin(hashMap, "${TABLE_OF_CONTENTS}", string9);
        printWriter.println(this.iipContent.getEntirePageContent("iip-main", hashMap));
    }

    protected String formatTime(long l) {
        long l2 = l / 1000L;
        long l3 = l2 % 60L;
        long l4 = l2 / 60L;
        long l5 = l4 % 60L;
        long l6 = l4 / 60L;
        String string = String.valueOf(l3);
        String string2 = String.valueOf(l5);
        String string3 = String.valueOf(l6);
        return string3 + ":" + (string2.length() == 1 ? "0" : "") + string2 + ":" + (string.length() == 1 ? "0" : "") + string;
    }

    protected String generateAnswer(Map<String, Fillin> map, boolean bl, boolean bl2) {
        try {
            TaskMetaData taskMetaData = this.task.getMetaData();
            this.addFillin(map, "${ANSWER_SCRIPTS}", this.generateNetworkConfiguration(map, taskMetaData.getAnswerNetwork().getNetworkConfiguration()));
            return this.iipContent.getPageContent("iip-answer", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateCommandEntries(Map<String, Fillin> map, List<IosLogEntry> list) {
        if (this.scores == null) {
            return "";
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (IosLogEntry iosLogEntry : list) {
                try {
                    if (!(iosLogEntry instanceof IosCommandEntry)) continue;
                    IosCommandEntry iosCommandEntry = (IosCommandEntry)iosLogEntry;
                    this.addFillin(map, "${TIMESTAMP}", XmlUtils.escape(iosCommandEntry.getDeviceTime()));
                    this.addFillin(map, "${DEVICE_NAME}", XmlUtils.escape(iosCommandEntry.getDevice()));
                    this.addFillin(map, "${PROMPT}", XmlUtils.escape(iosCommandEntry.getPrompt()));
                    this.addFillin(map, "${COMMAND}", XmlUtils.escape(iosCommandEntry.getCommand()));
                    stringBuilder.append(this.iipContent.getPageContent("iip-command-log-row", map));
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateCommandLog(Map<String, Fillin> map) {
        if (this.scores == null) {
            return "";
        }
        try {
            List<IosLogEntry> list;
            IosLog iosLog = this.scores.getWorkProduct().getIosLog();
            if (iosLog != null && (list = iosLog.getEntries()) != null && list.size() > 0) {
                this.addFillin(map, "${COMMAND_ROWS}", this.generateCommandEntries(map, list));
                return this.iipContent.getPageContent("iip-command-log", map);
            }
            return this.iipContent.getPageContent("iip-command-log-empty", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateFeedback(Map<String, Fillin> map) {
        if (this.scores == null) {
            return "";
        }
        try {
            this.addFillin(map, "${FEEDBACK_LIST}", this.generateFeedbackList(map));
            this.addFillin(map, "${PROFICIENCY_ESTIMATE_ROWS}", this.generateProficiencyEstimateRows(map));
            return this.iipContent.getPageContent("iip-feedback-section", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateVariables(Map<String, Fillin> map) {
        if (this.scores == null) {
            return "";
        }
        try {
            this.addFillin(map, "${VARIABLE_ROWS}", this.generateVariableRows(map));
            return this.iipContent.getPageContent("iip-variables-section", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateToc(Map<String, Fillin> map, boolean bl) {
        if (this.scores == null) {
            return "";
        }
        try {
            String string = "";
            if (this.displaygeneralInformationScoring) {
                string = string + "<br><a href=\"#general\">General Information</a>";
            }
            if (this.displayfeedbackSection) {
                string = string + "<br><a href=\"#feedback\">Feedback Section</a>";
            }
            if (this.displayvariableSection && bl) {
                string = string + "<br><a href=\"#vars\">Variables Table</a>";
            }
            string = string + "<br><a href=\"#scoring\">Scoring</a>";
            if (this.displayanswer && bl) {
                string = string + "<br><a href=\"#proposedsolution\">Proposed Solution</a>";
            }
            if (bl) {
                string = string + "<br><a href=\"#pka\">Link to Student's Activity File</a>";
            }
            if (bl) {
                string = string + "<br><a href=\"#timing\">Timing Statistics</a>";
            }
            if (bl) {
                string = string + "<br><a href=\"#finalrun\">Student's Final Running Configurations</a>";
            }
            if (bl) {
                string = string + "<br><a href=\"#cmdlog\">Combined Student Log</a>";
            }
            string = string + "<br>";
            this.addFillin(map, "${TOC}", string);
            return this.iipContent.getPageContent("iip-toc", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateFeedbackList(Map<String, Fillin> map) {
        if (!this.hasFeedback()) {
            return "";
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.feedbackStrings) {
                try {
                    this.addFillin(map, "${FEEDBACK}", XmlUtils.escape(string));
                    stringBuilder.append(this.iipContent.getPageContent("iip-feedback-list-item", map));
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            this.addFillin(map, "${FEEDBACK_MESSAGE_ITEMS}", stringBuilder.toString());
            return this.iipContent.getPageContent("iip-feedback-list", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateInstructionText(Map<String, Fillin> map, TaskMetaData taskMetaData) {
        try {
            Presentation presentation;
            Map<Integer, String> map2;
            StringBuilder stringBuilder = new StringBuilder();
            Map<Integer, String> map3 = map2 = taskMetaData == null || taskMetaData.getInitialNetwork() == null ? null : taskMetaData.getInitialNetwork().getPages();
            if (map2 != null && map2.size() > 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(map2.keySet());
                Collections.sort(arrayList);
                for (Integer n : arrayList) {
                    stringBuilder.append(this.stripInstructionHtml(map2.get(n)));
                    stringBuilder.append("\n");
                }
            } else if (this.scores != null && (presentation = this.scores.getPresentation()) != null) {
                for (int i = 1; i <= presentation.getNumberOfPages(); ++i) {
                    stringBuilder.append(this.stripInstructionHtml(presentation.getPage(i)));
                    stringBuilder.append("\n");
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateNetworkConfiguration(Map<String, Fillin> map, NetworkConfiguration networkConfiguration) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            List<String> list = networkConfiguration.getDeviceNames();
            for (String string : list) {
                try {
                    if (!this.iipClient.includeDeviceConfiguration(string, this.task)) continue;
                    stringBuilder2.setLength(0);
                    List<String> list2 = networkConfiguration.getConfigurationCommands(string);
                    Collections.sort(list2);
                    for (String string2 : list2) {
                        try {
                            String string3 = networkConfiguration.getConfiguration(string, string2);
                            string3 = string3.replaceAll(" ", "&nbsp;");
                            string3 = string3.replaceAll("\n", "<br>\n");
                            this.addFillin(map, "${COMMAND}", string2);
                            this.addFillin(map, "${COMMAND_RESULT}", string3);
                            stringBuilder2.append(this.iipContent.getPageContent("iip-device-script", map));
                        }
                        catch (Throwable throwable) {
                            Utilities.checkSwallow(throwable);
                        }
                    }
                    this.addFillin(map, "${DEVICE_NAME}", string);
                    this.addFillin(map, "${DEVICE_SCRIPTS}", stringBuilder2.toString());
                    stringBuilder.append(this.iipContent.getPageContent("iip-answer-script", map));
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateObservableRows(Map<String, Fillin> map, AssessmentCompoundObservable assessmentCompoundObservable, int n, boolean bl) {
        try {
            System.out.println("Generating Observable rows");
            StringBuilder stringBuilder = new StringBuilder();
            String string = "iip-top-level-observable-row";
            if (n == 1) {
                string = "iip-top-level-minus-one-observable-row";
            } else if (n == 2) {
                string = "iip-top-level-minus-two-observable-row";
            } else if (n == 3) {
                string = "iip-top-level-minus-three-observable-row";
            } else if (n == 4) {
                string = "iip-top-level-minus-four-observable-row";
            }
            CompoundEvidenceIdentification compoundEvidenceIdentification = this.scores == null ? null : this.scores.getCompoundEvidenceIdentification();
            CompoundObservable compoundObservable = compoundEvidenceIdentification == null ? null : compoundEvidenceIdentification.getCompoundObservableByPantherIdent(assessmentCompoundObservable.getPantherIdent());
            this.addFillin(map, "${NAME}", assessmentCompoundObservable.getName());
            this.addFillin(map, "${EARNED_POINTS}", compoundObservable == null ? assessmentCompoundObservable.getMaximumPoints() : compoundObservable.getEarnedPoints());
            this.addFillin(map, "${MAX_POINTS}", assessmentCompoundObservable.getMaximumPoints());
            stringBuilder.append(this.iipContent.getPageContent(string, map));
            if (n == this.task.getHighestCompoundLevel() - 1) {
                boolean bl2 = true;
                this.addFillin(map, "${NUMBER_OF_PRIMARY_OBSERVABLES}", assessmentCompoundObservable.getObservableReferences().size());
                for (String string2 : assessmentCompoundObservable.getObservableReferences()) {
                    try {
                        AssessmentPrimaryObservable assessmentPrimaryObservable = this.task.getPrimaryObservableByPantherIdent(string2);
                        stringBuilder.append(this.generatePrimaryObservableRow(map, assessmentPrimaryObservable, this.task.getHighestCompoundLevel(), bl2, bl));
                        bl2 = false;
                    }
                    catch (Throwable throwable) {
                        Utilities.checkSwallow(throwable);
                    }
                }
            } else {
                for (String string3 : assessmentCompoundObservable.getObservableReferences()) {
                    try {
                        AssessmentCompoundObservable assessmentCompoundObservable2 = this.task.getCompoundObservableByPantherIdent(string3);
                        stringBuilder.append(this.generateObservableRows(map, assessmentCompoundObservable2, n + 1, bl));
                    }
                    catch (Throwable throwable) {
                        Utilities.checkSwallow(throwable);
                    }
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generatePerformanceComponent(Map<String, Fillin> map, int n, AssessmentCompoundObservable assessmentCompoundObservable, boolean bl) {
        try {
            CompoundEvidenceIdentification compoundEvidenceIdentification;
            String string = this.generateObservableRows(map, assessmentCompoundObservable, 0, bl);
            String string2 = "";
            if (this.scores != null && (compoundEvidenceIdentification = this.scores.getCompoundEvidenceIdentification()) != null) {
                CompoundObservable compoundObservable = compoundEvidenceIdentification.getCompoundObservableByPantherIdent(assessmentCompoundObservable.getPantherIdent());
                try {
                    this.addFillin(map, "${EARNED_POINTS}", compoundObservable.getEarnedPoints());
                    string2 = this.iipContent.getPageContent("iip-performance-component-earned-points", map);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            this.addFillin(map, "${ANCHOR}", "PC" + n);
            this.addFillin(map, "${NAME}", XmlUtils.escape(assessmentCompoundObservable.getName()));
            this.addFillin(map, "${DESCRIPTION}", XmlUtils.escape(assessmentCompoundObservable.getDescription()));
            this.addFillin(map, "${POINTS_POSSIBLE}", assessmentCompoundObservable.getMaximumPoints());
            this.addFillin(map, "${EARNED_POINTS}", string2);
            this.addFillin(map, "${OBSERVABLE_ROWS}", string);
            return this.iipContent.getPageContent("iip-performance-component-section", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generatePerformanceComponents(Map<String, Fillin> map, boolean bl) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 1;
            for (AssessmentCompoundObservable assessmentCompoundObservable : this.topLevelObservables) {
                try {
                    stringBuilder.append(this.generatePerformanceComponent(map, n++, assessmentCompoundObservable, bl));
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generatePrimaryObservableRow(Map<String, Fillin> map, AssessmentPrimaryObservable assessmentPrimaryObservable, int n, boolean bl, boolean bl2) {
        try {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i <= n; ++i) {
                stringBuilder.append(this.iipContent.getPageContent("iip-primary-observable-leader", map));
            }
            System.out.println("generatePrimaryObservableRow");
            this.addFillin(map, "${LEADERS}", stringBuilder.toString());
            AssessmentWorkProductFeature assessmentWorkProductFeature = this.task.getWorkProductFeatureByPantherIdent(assessmentPrimaryObservable.getFirstObservableReference());
            String string2 = XmlUtils.escape(assessmentWorkProductFeature.getPtName());
            PrimaryObservable primaryObservable = null;
            WorkProductFeature workProductFeature = null;
            if (this.scores != null) {
                primaryObservable = this.scores.getPrimaryEvidenceIdentification().getPrimaryObservableByPantherIdent(assessmentPrimaryObservable.getPantherIdent());
            }
            if (this.scores != null) {
                workProductFeature = this.scores.getWorkProductFeatureIdentification().getWorkProductFeatureByName(string2);
            }
            if (bl2 && workProductFeature != null) {
                string = workProductFeature.getUserValue();
                if (string.trim().equalsIgnoreCase("") || string.trim().equalsIgnoreCase("__NULL__")) {
                    string = "no response";
                }
                this.addFillin(map, "${NAME}", string2 + ":" + string);
            } else {
                this.addFillin(map, "${NAME}", string2);
            }
            this.addFillin(map, "${CONNECTOR}", bl ? this.iipContent.getPageContent("iip-primary-observable-connector", map) : "");
            string = "iip-primary-observable-correct-row";
            if (primaryObservable != null && !primaryObservable.getCorrect()) {
                string = "iip-primary-observable-incorrect-row";
            }
            return this.iipContent.getPageContent(string, map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateVariableRows(Map<String, Fillin> map) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            ActivityVariable activityVariable = this.scores == null ? null : this.scores.getActivityVariablePool();
            for (int i = 0; i < activityVariable.getVariableSize(); ++i) {
                try {
                    String string = activityVariable.getNameAt(i);
                    String string2 = activityVariable.getValueAt(i);
                    map.put("${NAME}", new Fillin("${NAME}", "[[" + string + "]]"));
                    map.put("${VALUE}", new Fillin("${VALUE}", string2));
                    stringBuilder.append(this.iipContent.getPageContent("iip-variable-row", map));
                    this.displayvariableSection = true;
                    continue;
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateProficiencyEstimateRows(Map<String, Fillin> map) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            CompoundEvidenceIdentification compoundEvidenceIdentification = this.scores == null ? null : this.scores.getCompoundEvidenceIdentification();
            String string = this.iipContent.getPageContent("iip-proficiency-estimate-checkmark", map);
            String string2 = this.iipContent.getPageContent("iip-proficiency-estimate-empty", map);
            int n = 1;
            for (AssessmentCompoundObservable assessmentCompoundObservable : this.topLevelObservables) {
                try {
                    AssessmentReportingObservable assessmentReportingObservable = this.task.getReportingObservable(assessmentCompoundObservable);
                    String string3 = string2;
                    String string4 = string2;
                    String string5 = string2;
                    String string6 = string2;
                    if (compoundEvidenceIdentification != null && assessmentReportingObservable != null && assessmentReportingObservable.hasProficiency(compoundEvidenceIdentification)) {
                        String string7 = assessmentReportingObservable.getProficiency(compoundEvidenceIdentification);
                        if (string7.equalsIgnoreCase("novice")) {
                            string4 = string;
                        } else if (string7.equalsIgnoreCase("partial")) {
                            string5 = string;
                        } else if (string7.equalsIgnoreCase("proficient")) {
                            string6 = string;
                        } else {
                            string3 = string;
                        }
                    }
                    map.put("${ANCHOR}", new Fillin("${ANCHOR}", "#PC" + n++));
                    map.put("${NAME}", new Fillin("${NAME}", assessmentCompoundObservable.getName()));
                    map.put("${NONE}", new Fillin("${NONE}", string3));
                    map.put("${NOVICE}", new Fillin("${NOVICE}", string4));
                    map.put("${PARTIAL}", new Fillin("${PARTIAL}", string5));
                    map.put("${PROFICIENT}", new Fillin("${PROFICIENT}", string6));
                    stringBuilder.append(this.iipContent.getPageContent("iip-proficiency-estimate-row", map));
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected String generateTopologyUrl(Map<String, Fillin> map, boolean bl, boolean bl2, boolean bl3) {
        try {
            if (bl) {
                return "${HTTP_ROOT}/dummy-topology-" + (bl3 ? "initial" : "answer") + ".jpg";
            }
            if (this.task.getMetaData() != null) {
                Object object;
                TopologyGraphic topologyGraphic = null;
                if (bl3) {
                    object = this.task.getMetaData().getInitialNetwork();
                    if (object != null) {
                        topologyGraphic = ((Network)object).getTopologyGraphic();
                    }
                } else {
                    object = this.task.getMetaData().getAnswerNetwork();
                    if (object != null) {
                        topologyGraphic = ((Network)object).getTopologyGraphic();
                    }
                }
                if (topologyGraphic != null && topologyGraphic.getFileInfo() != null && this.iipClient.fileExists(this.assessment, this.form, this.task, topologyGraphic.getFileInfo().getFileName())) {
                    object = "${HTTP_ROOT}/";
                    if (bl2) {
                        object = (String)object + "info/" + this.assessment.getRelativeDirectory() + "/";
                    }
                    object = (String)object + topologyGraphic.getFileInfo().getFileName();
                    return object;
                }
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        return "";
    }

    protected String generateUserWork(Map<String, Fillin> map, String string) {
        if (this.scores == null) {
            return "";
        }
        try {
            Session session = this.scores.getSession();
            String string2 = this.generateCommandLog(map);
            String string3 = this.generateNetworkConfiguration(map, this.scores.getWorkProduct().getNetworkConfiguration());
            this.addFillin(map, "${ALLOWED_TIME}", this.formatTime(session.getTimeAllowed()));
            this.addFillin(map, "${APPLET}", string);
            this.addFillin(map, "${COMMAND_LOG}", string2);
            this.addFillin(map, "${ELAPSED_TIME}", this.formatTime(session.getTimeUsed()));
            this.addFillin(map, "${TIME_ENDED}", session.getEndTimeString());
            this.addFillin(map, "${TIME_STARTED}", session.getStartTimeString());
            this.addFillin(map, "${USER_SCRIPTS}", string3);
            return this.iipContent.getEntirePageContent("iip-user-work", map);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return "";
        }
    }

    protected List<String> getFeedbackStrings() {
        if (this.scores == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        CompoundEvidenceIdentification compoundEvidenceIdentification = this.scores.getCompoundEvidenceIdentification();
        int n = 0;
        int n2 = 0;
        for (AssessmentCompoundObservable assessmentCompoundObservable : this.topLevelObservables) {
            String string;
            String string2;
            CompoundObservable compoundObservable;
            AssessmentReportingObservable assessmentReportingObservable = this.task.getReportingObservable(assessmentCompoundObservable);
            if (assessmentReportingObservable != null) {
                ++n;
            }
            CompoundObservable compoundObservable2 = compoundObservable = assessmentReportingObservable == null ? null : compoundEvidenceIdentification.getCompoundObservableByPantherIdent(assessmentReportingObservable.getPantherIdent());
            if (compoundObservable != null) {
                ++n2;
            }
            if (compoundObservable == null || !compoundObservable.hasFeedback() || (string2 = (string = compoundObservable.getFeedback()) == null ? "" : string.trim()).length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected boolean hasFeedback() {
        return this.feedbackStrings != null && this.feedbackStrings.size() > 0;
    }

    protected void printTopLevelObservables() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AssessmentCompoundObservable assessmentCompoundObservable : this.topLevelObservables) {
            stringBuilder.append(assessmentCompoundObservable.getName());
            stringBuilder.append("\n");
        }
        System.out.println("In IipGenerator for form " + this.form.getVdsIdent() + " and task " + this.task.getVdsIdent() + "; top-level observables = \n" + stringBuilder);
    }

    protected String stripInstructionHtml(String string) {
        int n = 0;
        int n2 = string.length();
        String string2 = string.toLowerCase();
        int n3 = string2.indexOf("</body>");
        if (n3 >= 0) {
            n2 = n3;
        }
        if ((n3 = string2.indexOf("</html>")) >= 0 && n3 < n2) {
            n2 = n3;
        }
        if ((n3 = string2.indexOf("<html>")) >= 0) {
            n = n3 + 6;
        }
        if ((n3 = string2.indexOf("</head>")) >= 0 && n3 > n) {
            n = n3 + 7;
        }
        if ((n3 = string2.indexOf("<body>")) >= 0 && n3 > n) {
            n = n3 + 6;
        }
        return string.substring(n, n2);
    }

    protected static PageCollection getDefaultIipContent() throws Exception {
        if (DEFAULT_IIP_CONTENT != null) {
            return DEFAULT_IIP_CONTENT;
        }
        IipGenerator.initializeIipContent();
        return DEFAULT_IIP_CONTENT;
    }

    protected static void initializeIipContent() throws Exception {
        DEFAULT_IIP_CONTENT = new PageCollection();
        InputStreamReader inputStreamReader = new InputStreamReader(IipGenerator.class.getResourceAsStream("/iip-content.xml"));
        DEFAULT_IIP_CONTENT.read("/iip-content.xml", inputStreamReader);
        inputStreamReader.close();
    }
}

